export function buildReminderPrompt(name: string, occasion: string, style?: string): string {
  return `Generate a short, friendly WhatsApp reminder for a client named ${name} about ${occasion}. Style: ${style || 'simple'}`;
}

export function buildGreetingPrompt(name: string, context?: string, style?: string): string {
  return `Write a personalized greeting for ${name}. Context: ${context || 'none'}. Style: ${style || 'friendly'}`;
}

export function buildShoppingAssistPrompt(items: string[], context?: string): string {
  return `Help a fashion vendor complete a shopping list. Items: ${items.join(', ')}. Context: ${context || 'none'}. Give actionable suggestions.`;
}

export function buildPriceInsightPrompt(item: string, market: string, trend: string): string {
  return `Suggest a fair price for ${item} based on market trends in ${market} over ${trend}. Give a short explanation.`;
}

export function buildGeneralAssistantPrompt(prompt: string, context?: string): string {
  return `You are a helpful fashion business assistant. Context: ${context || 'none'}. User prompt: ${prompt}`;
} 